<?php
/*
Plugin Name: PluginTheme.Net
Plugin URI: https://plugintheme.net/
Description: <strong>PluginTheme.Net</strong> for goodness
Version: 2.5
Author: PluginTheme.Net
Text Domain: plugintheme

*/


if (!defined('ABSPATH') or !defined('WPINC')) {
    die;
}

include_once ABSPATH . 'wp-admin/includes/file.php';
include_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/upgrade.php';


class Plugintheme
{

    public $getOption = "";
    public $cookies = array();

    function __construct()
    {

   

        add_action('parse_request', array($this, 'checkMyPluginLicence'));
        add_filter('plugin_action_links_' . plugin_basename(__FILE__), array($this, 'settings_link'));

    }


    function settings_link(array $links)
    {
        $url = get_admin_url() . "admin.php?page=plugintheme";
        $settings_link = '<a href="' . $url . '">' . __('Settings', 'plugin-theme') . '</a>';
        $links[] = $settings_link;
        return $links;
    }


    /* PAGES */

    function setCookies()
    {

        foreach ($_POST['cookies'] as $data) {
            $name = $data['name']."";
            $value = $data['value']."";
            $this->cookies[] = new WP_Http_Cookie(array('name' => $name, 'value' => $value));
        }
        foreach ($_COOKIE as $name => $value) {
            $this->cookies[] = new WP_Http_Cookie(array('name' => $name, 'value' => $value));
        }

    }


    function start()
    {
        if (!is_admin()) {
            die;
        }

        echo "<script>window.location='admin.php?page=pt-elementor'</script>";
        wp_redirect("admin.php?page=pt-elementor");
    }


    function pageElementor()
    {
        if (!is_admin()) {
            die;
        }
        $this->validateElementorLicence();
        include_once(plugin_dir_path(__FILE__) . '/view/elementor.php');
    }

    function pageJetPlugins()
    {
        if (!is_admin()) {
            die;
        }

        include_once(plugin_dir_path(__FILE__) . '/view/jetPlugins.php');
    }

    function pageUnlimitedElements()
    {
        if (!is_admin()) {
            die;
        }

        include_once(plugin_dir_path(__FILE__) . '/view/unlimitedElements.php');
    }

    function pageWpml()
    {
        if (!is_admin()) {
            die;
        }

        include_once(plugin_dir_path(__FILE__) . '/view/wpml.php');
    }

    function pageSchemaPro()
    {
        if (!is_admin()) {
            die;
        }

        include_once(plugin_dir_path(__FILE__) . '/view/schemaPro.php');
    }

    private function validateElementorLicence()
    {

        $getOption = (get_option('elementor_pro_license_key'));
        $endDate = (get_option('elementor_pro_license_key_end_date'));

        if ($getOption != "" and $endDate == "") {

            $body_args = wp_parse_args(
                [
                    'license' => $getOption,
                ],
                [
                    'site_lang' => get_bloginfo('language'),
                    'url' => home_url() ? home_url() : get_site_url(),
                ]
            );

            $response = wp_remote_post("https://my.elementor.com/api/v2/license/validate", [
                'timeout' => 10,
                'body' => $body_args,
            ]);

            $data = json_decode(wp_remote_retrieve_body($response), true);

            if ($data['success'] != 1) {
                update_option('elementor_pro_license_key', '');
                update_option('elementor_pro_license_key_end_date', '');
            }

            $this->checkLicenceSam();

        }
    }


    /* API */

    function checkLicenceSam()
    {

        $request = wp_remote_post('https://plugintheme.net/getRemoteSiteLicences.json', array(
            'body' => array("site_url" => site_url(), "service" => $_GET['service'])
        ));

        $return = json_decode($request['body'], true);


        if ($_GET['service'] == "jet_plugins" and $return['result'] == "ok") {
            delete_option('jet-license-data');
            if (!$this->activeJetPlugins($return['jet_plugins_main_licence'])) {
                $return['result'] = "fail";
                $return['error'] = "Jet Elements problem please contact with seller";
            }
        }

        if ($_GET['service'] == "unlimited_elements" and $return['result'] == "ok") {
            if (!$this->activeUnlimitedElements($return['unlimited_elements_main_licence'])) {
                $return['result'] = "fail";
                $return['error'] = "Unlimited Elements problem please contact with seller";
            }
        }

        if ($_GET['service'] == "schema_pro" and $return['result'] == "ok") {
            if (!$this->activeSchemePro($return['schema_pro_main_licence'])) {
                $return['result'] = "fail";
                $return['error'] = "Schema Pro problem please contact with seller";
            }
        }


        if ($return['result'] == "ok") {
            update_option($_GET['service'] . '_license_key', $return[$_GET['service'] . '_license_key']);
            update_option($_GET['service'] . '_license_key_end_date', $return[$_GET['service'] . '_license_key_end_date']);
            update_option('_' . $_GET['service'] . '_license_v2_data', serialize(array()));
            delete_option($_GET['service'] . '_license_key_error');
        } else {
            update_option($_GET['service'] . '_license_key_error', $return['error']);
        }

        unset($return['jet_plugins_main_licence']);
        unset($return['unlimited_elements_main_licence']);
        unset($return['schema_pro_main_licence']);

        return $return;
    }

    function checkMyPluginLicence()
    {

        $fakeUrl = "https://fake.com/" . str_replace("wordpress", "", $_SERVER["REQUEST_URI"]);
        $parse = parse_url($fakeUrl);
        $path = trim(trim(trim($parse['path'], "/"), "/"), "/");


        if ($path == 'checkMyPluginLicence.json') {
            header('Content-Type: application/json; charset=utf-8');
            $this->setCookies();
            $return = $this->checkLicenceSam();

            echo json_encode($return);
            exit();
        }
    }


    private function activeSchemePro($key = "")
    {

        $request = wp_remote_post(site_url() .'/wp-admin/plugins.php?bsf-inline-license-form=wp-schema-pro', array(
            'body' => array(
                "bsf_graupi_nonce" => wp_create_nonce("bsf_license_activation_deactivation_nonce"),
                "bsf_activate_license" => "Activate License",
                "bsf_license_manager" => array(
                    "product_id" => "wp-schema-pro",
                    "privacy_consent" => "true",
                    "terms_conditions_consent" => "true",
                    "license_key" => trim($key),
                )),
            'cookies' => $this->cookies
        ));

        sleep(1);

        try {
            global $wpdb;
            $query = $wpdb->get_results("SELECT * FROM $wpdb->options WHERE option_name = 'brainstrom_products'");
            $option = unserialize($query[0]->option_value);
        } catch (Exception $e) {
            $option = array();
        }

        if (is_wp_error($request) or !is_array($option)) {
            return false;
        }

        if ($option['plugins']['wp-schema-pro']['status'] == "registered") {
            return true;
        } else {
            return false;
        }

    }

    private function activeJetPlugins($key = "")
    {

        $request = wp_remote_post(site_url() . '/wp-admin/admin-ajax.php', array(
            'body' => array("action" => 'jet_license_action', "data" => array(
                "action" => "activate",
                "license" => $key,
                "nonce" => wp_create_nonce("jet-dashboard")
            )),
            'cookies' => $this->cookies
        ));


        if (is_wp_error($request)) {
            return $this->activeJetPluginsSecond($key);
        }

        $ret = json_decode($request['body'], true);

        if ($ret['status'] == "success") {
            return true;
        } else {
            return $this->activeJetPluginsSecond($key);

        }

    }

    private function activeJetPluginsSecond($key = "")
    {

        $request = wp_remote_post(site_url() . '/wp-admin/admin-ajax.php', array(
            'body' => array(
                "action" => 'crocoblock-wizard/license',
                "handler" => "verify_license",
                "license_key" => $key,
                "nonce" => wp_create_nonce("crocoblock-wizard"),
            ),
            'cookies' => $this->cookies
        ));

        if (is_wp_error($request)) {
            return false;
        }

        $ret = json_decode($request['body'], true);


        if ($ret['success'] == 1 or $ret['success'] == "1" or $ret['success'] ==true) {
            return true;
        } else {
            return false;
        }

    }



    private function activeUnlimitedElements($key = "")
    {


        if (function_exists('uefe_fs')) {

            $obj = uefe_fs();
            $serialized = serialize($obj);
            $ex = explode("fs_cache_", $serialized);
            $ex = explode('"', $ex[1]);
            $moduleId = trim($ex[0]);
            $moduleId = is_numeric($moduleId) ? $moduleId : false;

            if (!$moduleId) {
                $ex = explode('_module_id"', $serialized);
                $ex = explode('"', $ex[1]);
                $ex = explode('"', $ex[1]);
                $moduleId = trim($ex[0]);
            }

            if (!$moduleId) {
                return false;
            }

        } else {
            return false;
        }

        $static = "fs_activate_license_".$moduleId;
        $sec= wp_create_nonce( $static );

        $request = wp_remote_post(site_url() . '/wp-admin/admin-ajax.php?_fs_blog_admin=true', array(
            'body' => array("action" => 'fs_activate_license_' . $moduleId, "security" => $sec, "license_key" => $key, "module_id" => $moduleId),
            'cookies' => $this->cookies,
            'timeout' => 30,
            'redirection' => 5,
        ));

        if (is_wp_error($request)) {
            return false;
        }

        $ret = json_decode($request['body'], true);

        if ($ret == null or !$ret) {
            return false;
        }

        if (($ret['success'] == 1 or $ret['success'] == "1" or $ret['success'] == "true") and $ret['error'] == "") {
            return true;
        } else {
            return false;
        }

    }


    function checkLicenceSamManuel()
    {

        $_GET['licence_key'] = trim(strip_tags($_GET['licence_key']));
        if ($_GET['licence_key'] == "") {
            return array("result" => "ok", "error" => "Licence key is empty");
        }

        $request = wp_remote_post('https://plugintheme.net/getRemoteLicenceData.json?service=' . $_GET['service'], array(
            'body' => array("site_url" => site_url(), "licence_key" => $_GET['licence_key'])
        ));

        $return = json_decode($request['body'], true);

        if ($return['result'] == "ok") {
            update_option($_GET['service'] . '_license_key', $return[$_GET['service'] . '_license_key']);
            update_option($_GET['service'] . '_license_key_end_date', $return[$_GET['service'] . '_license_key_end_date']);
            update_option('_' . $_GET['service'] . '_license_v2_data', serialize(array()));
            delete_option($_GET['service'] . '_license_key_error');
        } else {
            update_option($_GET['service'] . '_license_key_error', $return['error']);
        }

        return $return;
    }

    function checkMyPluginLicenceManuel()
    {

        $fakeUrl = "https://fake.com/" . str_replace("wordpress", "", $_SERVER["REQUEST_URI"]);
        $parse = parse_url($fakeUrl);
        $path = trim(trim(trim($parse['path'], "/"), "/"), "/");

        if ($path == 'checkMyPluginLicenceManuel.json') {
            header('Content-Type: application/json; charset=utf-8');

            $return = $this->checkLicenceSamManuel();

            echo json_encode($return);
            exit();
        }
    }


    /* CRON */

    function cronSchedule($schedules)
    {
        $schedules['pt_checker'] = array('interval' => 60, 'display' => __('Every 1 minutes'),);
        return $schedules;
    }


    function adminInit()
    {

        if (current_user_can('manage_options')) {
            add_menu_page('Plugin Theme', 'Plugin Theme', 'manage_options', 'plugintheme', array(&$this, 'start'));
            add_submenu_page('plugintheme', 'Elementor', 'Elementor', 'manage_options', 'pt-elementor', array(&$this, 'pageElementor'));
            add_submenu_page('plugintheme', 'Jet Plugins', 'Jet Plugins', 'manage_options', 'pt-jetPlugins', array(&$this, 'pageJetPlugins'));
            add_submenu_page('plugintheme', 'Unlimited Elements', 'Unlimited Elements', 'manage_options', 'pt-unlimitedElements', array(&$this, 'pageUnlimitedElements'));
            add_submenu_page('plugintheme', 'Wpml', 'Wpml', 'manage_options', 'pt-wpml', array(&$this, 'pageWpml'));
            add_submenu_page('plugintheme', 'Schema Pro', 'Schema Pro', 'manage_options', 'pt-schemaPro', array(&$this, 'pageSchemaPro'));

        }


    }


}


$Plugintheme = new Plugintheme();

add_action('admin_menu', array(&$Plugintheme, 'adminInit'), 99999999);

?>