<?php
namespace Impak\Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; }

class Widget_Loan_Comparator extends \Elementor\Widget_Base {

    public function get_name() {
        return 'impak_loan_comparator';
    }

    public function get_title() {
        return __( 'Impak Loan Comparator', 'impak-loan-comparator' );
    }

    public function get_icon() {
        return 'eicon-form-horizontal';
    }

    public function get_categories() {
        return [ 'general' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            [ 'label' => __( 'Contenido', 'impak-loan-comparator' ) ]
        );

        $this->add_control(
            'heading',
            [
                'label' => __( 'Título', 'impak-loan-comparator' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Comparador de préstamos en línea', 'impak-loan-comparator' ),
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        // Enqueue assets when widget renders on frontend
        wp_enqueue_style( 'impak-lc-style' );
        wp_enqueue_script( 'impak-lc-frontend' );
        
        // Read configurable options from settings
        $amount_raw = \Impak_LC_Settings::get( 'amount_options', '' );
        $term_raw   = \Impak_LC_Settings::get( 'term_options', '' );
        $amount_placeholder = trim( (string) \Impak_LC_Settings::get( 'amount_placeholder', '' ) );
        if ( $amount_placeholder === '' ) { $amount_placeholder = __( 'Selecciona el monto', 'impak-loan-comparator' ); }
        $term_placeholder = trim( (string) \Impak_LC_Settings::get( 'term_placeholder', '' ) );
        if ( $term_placeholder === '' ) { $term_placeholder = __( 'Selecciona el plazo', 'impak-loan-comparator' ); }

        $amount_options = [];
        if ( ! empty( $amount_raw ) ) {
            foreach ( preg_split( '/\r?\n/', $amount_raw ) as $line ) {
                $line = trim( $line );
                if ( $line === '' ) { continue; }
                $parts = array_map( 'trim', explode( '|', $line, 2 ) );
                $value = sanitize_text_field( $parts[0] );
                $label = sanitize_text_field( isset( $parts[1] ) ? $parts[1] : $parts[0] );
                $amount_options[] = [ 'value' => $value, 'label' => $label ];
            }
        } else {
            // Defaults
            $amount_options = [
                [ 'value' => '50-200', 'label' => '50 - 200' ],
                [ 'value' => '200-500', 'label' => '200 - 500' ],
                [ 'value' => '500-1000', 'label' => '500 - 1000' ],
                [ 'value' => '1000-2000', 'label' => '1000 - 2000' ],
                [ 'value' => '2000-5000', 'label' => '2000 - 5000' ],
            ];
        }

        $term_options = [];
        if ( ! empty( $term_raw ) ) {
            foreach ( preg_split( '/\r?\n/', $term_raw ) as $line ) {
                $line = trim( $line );
                if ( $line === '' ) { continue; }
                $parts = array_map( 'trim', explode( '|', $line, 2 ) );
                $value = sanitize_text_field( $parts[0] );
                $label = sanitize_text_field( isset( $parts[1] ) ? $parts[1] : $parts[0] );
                $term_options[] = [ 'value' => $value, 'label' => $label ];
            }
        } else {
            // Defaults
            $term_options = [
                [ 'value' => '30', 'label' => '30' ],
                [ 'value' => '60', 'label' => '60' ],
                [ 'value' => '90', 'label' => '90' ],
            ];
        }
        ?>
        <div class="impak-lc" data-procesoid="">
            <h2 class="impak-lc__title"><?php echo esc_html( $settings['heading'] ); ?></h2>
            <form class="impak-lc__form impak-lc__form--step1" action="#" method="post" onsubmit="return false;">
                <div class="impak-lc__row">
                    <div class="impak-lc__field impak-lc__field--full">
                        <label for="impak-lc-doc-number"><?php esc_html_e('Documento', 'impak-loan-comparator'); ?> <span class="req">*</span></label>
                        <div class="impak-lc__doc-combo">
                            <div class="impak-lc__doc-select">
                                <select id="impak-lc-doc-type" name="doc_type" required>
                                    <option value="" selected disabled><?php esc_html_e('DNI / CE', 'impak-loan-comparator'); ?></option>
                                    <option value="D">DNI</option>
                                    <option value="CE">CE</option>
                                </select>
                            </div>
                            <input id="impak-lc-doc-number" type="text" name="doc_number" placeholder="<?php esc_attr_e('Nro de documento', 'impak-loan-comparator'); ?>" required />
                        </div>
                    </div>
                </div>
                <div class="impak-lc__row">
                    <div class="impak-lc__field impak-lc__field--full">
                        <?php $amount_max = (int) \Impak_LC_Settings::get( 'amount_max', 1500 ); if($amount_max < 50){ $amount_max = 50; } ?>
                        <div class="impak-lc__amount">
                            <div class="impak-lc__amount-head">
                                <label for="impak-lc-amount-range" class="impak-lc__amount-title"><?php esc_html_e('¿Cuánto necesitas?', 'impak-loan-comparator'); ?></label>
                                <div class="impak-lc__amount-box"><span class="impak-lc__amount-box-currency">S/</span><span class="impak-lc__amount-value" id="impak-lc-amount-value">50.00</span></div>
                            </div>
                            <div class="impak-lc__range-wrap">
                                <button type="button" class="impak-lc__range-btn impak-lc__range-btn--minus" aria-label="-50">−</button>
                                <input id="impak-lc-amount-range" class="impak-lc__amount-range" type="range" min="50" max="<?php echo esc_attr($amount_max); ?>" step="50" value="50" data-min="50" data-max="<?php echo esc_attr($amount_max); ?>" data-step="50" data-thumb="40" aria-label="<?php esc_attr_e('Monto a Solicitar', 'impak-loan-comparator'); ?>" />
                                <button type="button" class="impak-lc__range-btn impak-lc__range-btn--plus" aria-label="+50">+</button>
                            </div>
                            <input type="hidden" name="amount" id="impak-lc-amount-hidden" value="50" />
                        </div>
                    </div>
                </div>
                <div class="impak-lc__row">
                    <div class="impak-lc__field impak-lc__field--full">
                        <label for="impak-lc-term"><?php esc_html_e('Plazo de pago (días)', 'impak-loan-comparator'); ?> <span class="req">*</span></label>
                        <div class="impak-lc__select-wrap">
                            <select id="impak-lc-term" name="term" required>
                                <option value="" selected disabled><?php echo esc_html( $term_placeholder ); ?></option>
                                <?php foreach ( $term_options as $opt ) : ?>
                                    <option value="<?php echo esc_attr( $opt['value'] ); ?>"><?php echo esc_html( $opt['label'] ); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="impak-lc__actions">
                    <button type="submit" class="impak-lc__btn"><?php esc_html_e('Siguiente', 'impak-loan-comparator'); ?></button>
                </div>
            </form>

            <form class="impak-lc__form impak-lc__form--step2" action="#" method="post" onsubmit="return false;" style="display:none;">
                <div class="impak-lc__row">
                    <div class="impak-lc__field impak-lc__field--half">
                        <label for="impak-lc-firstname"><?php esc_html_e('Nombres', 'impak-loan-comparator'); ?> <span class="req">*</span></label>
                        <input id="impak-lc-firstname" type="text" name="nombres" maxlength="20" placeholder="<?php esc_attr_e('Nombres', 'impak-loan-comparator'); ?>" required />
                    </div>
                    <div class="impak-lc__field impak-lc__field--half">
                        <label for="impak-lc-lastname"><?php esc_html_e('Apellidos', 'impak-loan-comparator'); ?> <span class="req">*</span></label>
                        <input id="impak-lc-lastname" type="text" name="apellidos" maxlength="20" placeholder="<?php esc_attr_e('Apellidos', 'impak-loan-comparator'); ?>" required />
                    </div>
                </div>
                <div class="impak-lc__row">
                    <div class="impak-lc__field impak-lc__field--half">
                        <label for="impak-lc-email"><?php esc_html_e('Correo electrónico', 'impak-loan-comparator'); ?> <span class="req">*</span></label>
                        <input id="impak-lc-email" type="email" name="correoelectronico" placeholder="nombre@correo.com" required />
                    </div>
                    <div class="impak-lc__field impak-lc__field--half">
                        <label for="impak-lc-phone"><?php esc_html_e('Celular', 'impak-loan-comparator'); ?> <span class="req">*</span></label>
                        <input id="impak-lc-phone" type="text" name="telefono" placeholder="9XXXXXXXX" inputmode="numeric" pattern="9[0-9]{8}" maxlength="9" required />
                    </div>
                </div>
                <div class="impak-lc__actions">
                    <button type="submit" class="impak-lc__btn"><?php esc_html_e('Obtener resultados', 'impak-loan-comparator'); ?></button>
                </div>
            </form>

            <div class="impak-lc__results" style="display:none;">
                <div class="impak-lc__results-list"></div>
            </div>
        </div>
        <?php
    }
}
