<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class Impak_Loan_Comparator {
    private static $instance = null;

    public static function instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        // i18n
        add_action( 'init', [ $this, 'load_textdomain' ] );

        // Register widget
        add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );

        // Register assets (enqueue later to win CSS precedence vs page builders)
        add_action( 'wp_enqueue_scripts', [ $this, 'register_assets' ], 20 );

        // Admin settings
        require_once IMPAK_LC_PLUGIN_DIR . 'includes/admin/class-impak-lc-settings.php';
        Impak_LC_Settings::init();

        // Shortcode
        require_once IMPAK_LC_PLUGIN_DIR . 'includes/shortcodes/class-impak-lc-shortcode.php';
        add_action( 'init', [ 'Impak_LC_Shortcode', 'register' ] );

        // REST controller
        require_once IMPAK_LC_PLUGIN_DIR . 'includes/rest/class-impak-lc-rest.php';
        add_action( 'rest_api_init', [ 'Impak_LC_REST', 'register_routes' ] );
    }

    public function load_textdomain() {
        load_plugin_textdomain( 'impak-loan-comparator', false, dirname( plugin_basename( IMPAK_LC_PLUGIN_FILE ) ) . '/languages' );
    }

    public function register_assets() {
        wp_register_style(
            'impak-lc-style',
            IMPAK_LC_PLUGIN_URL . 'assets/css/style.css',
            [],
            IMPAK_LC_VERSION
        );

        wp_register_script(
            'impak-lc-frontend',
            IMPAK_LC_PLUGIN_URL . 'assets/js/frontend.js',
            [ 'jquery' ],
            IMPAK_LC_VERSION,
            true
        );

        // Localize for future API integration
        wp_localize_script( 'impak-lc-frontend', 'ImpakLC', [
            'restUrl'       => esc_url_raw( rest_url() ),
            'restNamespace' => 'impak-lc/v1',
            'nonce'         => wp_create_nonce( 'wp_rest' ),
            'publicNonce'   => wp_create_nonce( 'impak_lc' ),
            'imageBase'     => trailingslashit( IMPAK_LC_PLUGIN_URL . 'assets/img' ),
            'amountMax'     => (int) \Impak_LC_Settings::get( 'amount_max', 1500 ),
        ] );
    }

    public function register_widgets( $widgets_manager ) {
        require_once IMPAK_LC_PLUGIN_DIR . 'includes/widgets/class-widget-loan-comparator.php';
        $widgets_manager->register( new \Impak\Elementor\Widget_Loan_Comparator() );
    }
}
