<?php
/**
 * Plugin Name:       Impak Loan Comparator (Elementor)
 * Description:       Estructura base de un widget de Elementor para un comparador de préstamos.
 * Version:           0.1.1
 * Author:            Impak
 * Text Domain:       impak-loan-comparator
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

if ( ! defined( 'IMPAK_LC_VERSION' ) ) {
    define( 'IMPAK_LC_VERSION', '0.1.1' );
}

// Paths
if ( ! defined( 'IMPAK_LC_PLUGIN_FILE' ) ) {
    define( 'IMPAK_LC_PLUGIN_FILE', __FILE__ );
}
if ( ! defined( 'IMPAK_LC_PLUGIN_DIR' ) ) {
    define( 'IMPAK_LC_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'IMPAK_LC_PLUGIN_URL' ) ) {
    define( 'IMPAK_LC_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

/**
 * Check Elementor dependency
 */
function impak_lc_missing_dependencies_notice() {
    echo '<div class="notice notice-error"><p>' . esc_html__( 'Impak Loan Comparator requiere Elementor activado.', 'impak-loan-comparator' ) . '</p></div>';
}

function impak_lc_plugins_loaded() {
    // Requires Elementor
    if ( ! did_action( 'elementor/loaded' ) ) {
        add_action( 'admin_notices', 'impak_lc_missing_dependencies_notice' );
        return;
    }

    // Load main class
    require_once IMPAK_LC_PLUGIN_DIR . 'includes/class-impak-loan-comparator.php';
    Impak_Loan_Comparator::instance();
}
add_action( 'plugins_loaded', 'impak_lc_plugins_loaded' );
