(function($){
  function setLoading($form, isLoading){
    var $btn = $form.find('.impak-lc__btn');
    if(isLoading){
      $btn.data('text', $btn.text());
      $btn.prop('disabled', true).text('Cargando...');
    } else {
      $btn.prop('disabled', false).text($btn.data('text') || 'Siguiente');
    }
  }

  // Amount slider wiring
  function setRangeFill($range, v){
    if(!$range || !$range.length){ return; }
    var min = parseInt($range.attr('min')||'0',10);
    var max = parseInt($range.attr('max')||'100',10);
    if(isNaN(min) || isNaN(max) || max <= min){ return; }
    var pct = ((v - min) * 100) / (max - min);
    if(!isFinite(pct)) pct = 0;
    // Add half-thumb offset so fill reaches the thumb center visually
    var rangeWidth = ($range[0] && $range[0].getBoundingClientRect) ? $range[0].getBoundingClientRect().width : 0;
    var thumbPx = parseInt($range.attr('data-thumb')||'40', 10); // default 40px as in CSS
    var offsetPct = rangeWidth ? (thumbPx/2) / rangeWidth * 100 : 0;
    var pctAdj = Math.max(0, Math.min(100, pct + offsetPct));
    // Two-layer background to avoid inner seams: sized solid fill over base gray
    var fill = 'linear-gradient(#045CB4, #045CB4) 0 0 / '+ pctAdj +'% 100% no-repeat, #eaeefb';
    $range.css('background', fill);
  }

  function updateAmountUI($widget, val){
    var v = parseInt(val, 10); if(isNaN(v)) v = 50;
    var $val = $widget.find('#impak-lc-amount-value');
    var $hidden = $widget.find('#impak-lc-amount-hidden');
    var $range = $widget.find('#impak-lc-amount-range');
    $val.text(v);
    $hidden.val(v);
    if($range.length && $range.val() !== String(v)){ $range.val(v); }
    setRangeFill($range, v);
  }

  // Change via dragging
  $(document).on('input change', '.impak-lc #impak-lc-amount-range', function(){
    var $widget = $(this).closest('.impak-lc');
    updateAmountUI($widget, $(this).val());
  });

  // Buttons +/-
  $(document).on('click', '.impak-lc .impak-lc__range-btn--minus', function(){
    var $widget = $(this).closest('.impak-lc');
    var $range = $widget.find('#impak-lc-amount-range');
    if(!$range.length) return;
    var step = parseInt($range.attr('step')||'50',10);
    var min  = parseInt($range.attr('min')||'50',10);
    var cur  = parseInt($range.val()||String(min),10);
    var next = Math.max(min, cur - step);
    updateAmountUI($widget, next);
  });

  $(document).on('click', '.impak-lc .impak-lc__range-btn--plus', function(){
    var $widget = $(this).closest('.impak-lc');
    var $range = $widget.find('#impak-lc-amount-range');
    if(!$range.length) return;
    var step = parseInt($range.attr('step')||'50',10);
    var max  = parseInt($range.attr('max')|| (ImpakLC && ImpakLC.amountMax ? ImpakLC.amountMax : '1500'),10);
    var cur  = parseInt($range.val()||'50',10);
    var next = Math.min(max, cur + step);
    updateAmountUI($widget, next);
  });

  // Initialize on load
  $(function(){
    $('.impak-lc').each(function(){
      var $w = $(this);
      var $range = $w.find('#impak-lc-amount-range');
      if($range.length){ updateAmountUI($w, $range.val()); }
    });
  });

  // Live constraints for Step 2 fields
  $(document).on('input', '#impak-lc-firstname, #impak-lc-lastname', function(){
    var $inp = $(this);
    var v = ($inp.val()||'').replace(/[^A-Za-zÁÉÍÓÚÜÑáéíóúüñ\s]/g, '').slice(0,20);
    if($inp.val() !== v){ $inp.val(v); }
    clearFieldError($inp);
  });
  $(document).on('blur', '#impak-lc-firstname, #impak-lc-lastname', function(){
    var $inp = $(this);
    var v = ($inp.val()||'');
    if(!validateName(v)){
      showFieldError($inp, 'Solo letras y espacios, máximo 20 caracteres.');
    }
  });

  $(document).on('input', '#impak-lc-phone', function(){
    var $inp = $(this);
    var v = ($inp.val()||'').replace(/\D/g,'').slice(0,9);
    if($inp.val() !== v){ $inp.val(v); }
    clearFieldError($inp);
  });
  $(document).on('blur', '#impak-lc-phone', function(){
    var $inp = $(this);
    var v = ($inp.val()||'');
    if(!validatePhone(v)){
      showFieldError($inp, 'El celular debe tener 9 dígitos y empezar con 9.');
    }
  });

  $(document).on('blur', '#impak-lc-email', function(){
    var $inp = $(this);
    var v = ($inp.val()||'');
    if(!validateEmail(v)){
      showFieldError($inp, 'Ingresa un correo válido (ej. nombre@correo.com).');
    } else {
      clearFieldError($inp);
    }
  });

  $(document).on('input', '#impak-lc-email', function(){
    var $inp = $(this);
    var v = ($inp.val()||'');
    if(validateEmail(v)){
      clearFieldError($inp);
    }
  });

  function validateDocument(docType, docNumber){
    docType = (docType || '').trim();
    docNumber = (docNumber || '').trim();
    if(!docType){ return 'Selecciona el tipo de documento.'; }
    if(!docNumber){ return 'Ingresa el número de documento.'; }
    if(docType === 'D'){
      // DNI peruano: 8 dígitos numéricos
      if(!/^\d{8}$/.test(docNumber)){
        return 'El DNI debe tener 8 dígitos numéricos.';
      }
    } else if (docType === 'CE'){
      // Carné de Extranjería: 9 a 12 caracteres alfanuméricos (tolerante)
      if(!/^[A-Za-z0-9]{9,12}$/.test(docNumber)){
        return 'El Carné de Extranjería debe tener entre 9 y 12 caracteres alfanuméricos (sin espacios).';
      }
    }
    return null;
  }

  function clearFieldError($input){
    $input.removeClass('is-invalid').attr('aria-invalid', 'false');
    var $wrap = $input.closest('.impak-lc__field');
    $wrap.find('.impak-lc__error').remove();
    // Also clear invalid style on unified doc combo if present
    var $combo = $wrap.find('.impak-lc__doc-combo');
    if($combo.length){ $combo.removeClass('is-invalid'); }
  }

  function showFieldError($input, message){
    clearFieldError($input);
    $input.addClass('is-invalid').attr('aria-invalid', 'true');
    var $wrap = $input.closest('.impak-lc__field');
    $('<div class="impak-lc__error"></div>').text(message).appendTo($wrap);
    // Mirror invalid to unified doc combo if present
    var $combo = $wrap.find('.impak-lc__doc-combo');
    if($combo.length){ $combo.addClass('is-invalid'); }
  }

  function validateEmail(email){
    email = (email||'').trim();
    if(email === '') return false;
    // Basic structure local@domain.tld
    var basic = /^[A-Za-z0-9._%+\-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,}$/;
    if(!basic.test(email)) return false;
    // Additional checks: no consecutive dots and valid domain labels
    var parts = email.split('@');
    if(parts.length !== 2) return false;
    var local = parts[0];
    var domain = parts[1];
    if(local.indexOf('..') !== -1) return false;
    if(domain.indexOf('..') !== -1) return false;
    var labels = domain.split('.');
    if(labels.length < 2) return false; // require at least one dot
    for(var i=0;i<labels.length;i++){
      var lbl = labels[i];
      if(lbl.length === 0 || lbl.length > 63) return false;
      if(!/^[A-Za-z0-9-]+$/.test(lbl)) return false;
      if(lbl.charAt(0) === '-' || lbl.charAt(lbl.length-1) === '-') return false;
    }
    var tld = labels[labels.length - 1];
    if(!/^[A-Za-z]{2,63}$/.test(tld)) return false;
    return true;
  }

  function validatePhone(pePhone){
    pePhone = (pePhone||'').trim();
    // Must be 9 digits and start with 9
    return /^9\d{8}$/.test(pePhone);
  }

  function validateName(name){
    name = (name||'').trim();
    // Allow letters (including common accents) and spaces, 1-20 chars
    return /^[A-Za-zÁÉÍÓÚÜÑáéíóúüñ ]{1,20}$/.test(name);
  }

  function apiUrl(path){
    return (ImpakLC.restUrl || '') + (ImpakLC.restNamespace ? ImpakLC.restNamespace : '') + path;
  }

  function setAuthHeaders(xhr){
    if(ImpakLC){
      if(ImpakLC.nonce){ xhr.setRequestHeader('X-WP-Nonce', ImpakLC.nonce); }
      if(ImpakLC.publicNonce){ xhr.setRequestHeader('X-Impak-Nonce', ImpakLC.publicNonce); }
    }
  }

  // Apply live constraints to the unified document field
  function applyDocConstraints($widget){
    var $type = $widget.find('[name="doc_type"]');
    var $num  = $widget.find('[name="doc_number"]');
    var t = ($type.val() || '').trim();
    if(t === 'D'){
      $num.attr({ maxlength: 8, inputmode: 'numeric', pattern: '\\d{8}' });
      // Keep only digits and max 8
      var v = ($num.val()||'').replace(/\D/g, '').slice(0,8);
      $num.val(v).attr('placeholder','DNI (8 dígitos)');
    } else if (t === 'CE'){
      $num.attr({ maxlength: 12, inputmode: 'text', pattern: '[A-Za-z0-9]{9,12}' });
      var v2 = ($num.val()||'').replace(/[^A-Za-z0-9]/g, '').slice(0,12);
      $num.val(v2).attr('placeholder','CE (9 a 12 caracteres)');
    } else {
      $num.removeAttr('maxlength pattern inputmode').attr('placeholder','Nro de documento');
    }
  }

  // When document type changes, enforce constraints
  $(document).on('change', '.impak-lc [name="doc_type"]', function(){
    var $widget = $(this).closest('.impak-lc');
    applyDocConstraints($widget);
    // Clear previous errors as user is changing type
    clearFieldError($widget.find('[name="doc_number"]'));
  });

  // On input, keep enforcing constraints and limit lengths
  $(document).on('input', '.impak-lc [name="doc_number"]', function(){
    var $widget = $(this).closest('.impak-lc');
    var $num = $(this);
    var t = ($widget.find('[name="doc_type"]').val()||'').trim();
    if(t === 'D'){
      $num.val(($num.val()||'').replace(/\D/g,'').slice(0,8));
    } else if (t === 'CE'){
      $num.val(($num.val()||'').replace(/[^A-Za-z0-9]/g,'').slice(0,12));
    } else {
      // No tipo seleccionado: por defecto permitir solo dígitos y hasta 8
      $num.val(($num.val()||'').replace(/\D/g,'').slice(0,8));
    }
    validateDocLive($widget);
  });

  // Si enfoca el número sin tipo seleccionado, mostrar mensaje para elegir tipo
  $(document).on('focus', '.impak-lc [name="doc_number"]', function(){
    var $widget = $(this).closest('.impak-lc');
    var t = ($widget.find('[name="doc_type"]').val()||'').trim();
    if(!t){
      showFieldError($widget.find('[name="doc_type"]'), 'Selecciona el tipo de documento.');
    }
  });

  // Live validation on change/blur as well
  $(document).on('change blur', '.impak-lc [name="doc_type"], .impak-lc [name="doc_number"]', function(){
    var $widget = $(this).closest('.impak-lc');
    validateDocLive($widget);
  });

  function validateDocLive($widget){
    var $type = $widget.find('[name="doc_type"]');
    var $num  = $widget.find('[name="doc_number"]');
    // Clear first
    clearFieldError($type); clearFieldError($num);
    var t = ($type.val()||'').trim();
    var n = ($num.val()||'').trim();
    if(!t){
      showFieldError($type, 'Selecciona el tipo de documento.');
      return;
    }
    if(t === 'D'){
      if(n && !/^\d{8}$/.test(n)){
        showFieldError($num, 'El DNI debe tener 8 dígitos.');
      }
    } else if (t === 'CE'){
      if(n && !/^[A-Za-z0-9]{9,12}$/.test(n)){
        showFieldError($num, 'El CE debe tener entre 9 y 12 caracteres alfanuméricos.');
      }
    }
  }

  function renderResults($wrap, data){
    var list = Array.isArray(data && data.resultados) ? data.resultados : [];
    var html = '';
    var $results = $wrap.find('.impak-lc__results');
    if(!list.length){
      html = ''
        + '<div class="impak-lc__no-results">'
        +   '<p><strong>No hay ofertas disponibles</strong> para los criterios seleccionados.</p>'
        +   '<p>Prueba con otro monto o plazo.</p>'
        +   '<div class="impak-lc__actions"><button type="button" class="impak-lc__btn impak-lc__btn--sm impak-lc__back">Volver</button></div>'
        + '</div>';
      // Hide forms and show results area
      $wrap.find('.impak-lc__form').hide();
      $results.show();
      $results.removeClass('impak-lc__results--overlay');
      // Add root state class to guarantee forms stay hidden
      $wrap.addClass('impak-lc--no-results');
    } else {
      $results.removeClass('impak-lc__results--overlay');
      $wrap.removeClass('impak-lc--no-results');
      list.sort(function(a,b){ return (a.prioridad||999) - (b.prioridad||999); });
      list.forEach(function(item){
        var logoHtml = '';
        if(item && ImpakLC && ImpakLC.imageBase){
          var code = String(item.codigoentidad || item.codigo || '').trim();
          if(code){
            var src = ImpakLC.imageBase + code + '.jpeg';
            logoHtml = '<img class="impak-lc__logo" src="'+ src +'" alt="'+ (item.nombre||'Entidad') +'" onerror="this.style.display=\'none\'" />';
          }
        }
        var entidadId = (item && (item.id || item.codigoentidad)) ? (item.id || item.codigoentidad) : '';
        html += '\n<div class="impak-lc__card" data-entidadid="'+ entidadId +'"'+ (item.url ? ' data-url="'+ String(item.url).replace(/"/g,'&quot;') +'"' : '') + '>'
             +   '<div class="impak-lc__card-hd impak-lc__card-hd--stack">'
             +     (logoHtml ? '<div class="impak-lc__card-logo impak-lc__card-logo--center">'+ logoHtml +'</div>' : '')
             +     '<div class="impak-lc__card-title impak-lc__card-title--center">'+ (item.nombre||'Entidad') +'</div>'
             +   '</div>'
             +   '<div class="impak-lc__card-row"><strong>Monto:</strong> '+ (item.monto||'-') +'</div>'
             +   '<div class="impak-lc__card-row"><strong>Plazo:</strong> '+ (item.plazo||'-') +'</div>'
             +   '<div class="impak-lc__card-row"><strong>Tasa:</strong> '+ (item.tasa||'-') +'</div>'
             +   ''
             +   '<div class="impak-lc__card-actions">'
             +     '<button class="impak-lc__btn impak-lc__btn--sm impak-lc__notify">Seleccionar</button>'
             +   '</div>'
             + '</div>';
      });
    }
    $wrap.find('.impak-lc__results-list').html(html);
    // Defensive: ensure forms are hidden if no-results is present
    if($wrap.find('.impak-lc__no-results').length){
      $wrap.find('.impak-lc__form').hide();
      $wrap.addClass('impak-lc--no-results');
      $wrap.find('.impak-lc__results').show();
    }
  }

  function showResultsLoading($widget, msg){
    var $list = $widget.find('.impak-lc__results-list');
    $list.html('<div class="impak-lc__loading">'+ (msg || 'Buscando resultados...') +'</div>');
  }

  function fetchResultsOnce(procesoid){
    return $.ajax({ url: apiUrl('/results'), method: 'GET', data: { procesoid: procesoid }, beforeSend: setAuthHeaders });
  }

  function pollResults($widget, procesoid, opts){
    opts = opts || {};
    var maxAttempts = opts.maxAttempts || 10;
    var intervalMs  = opts.intervalMs  || 3000;
    var attempt = 0;

    function attemptFetch(){
      attempt++;
      fetchResultsOnce(procesoid)
        .done(function(r){
          var data = r && r.data ? r.data : null;
          var has = data && Array.isArray(data.resultados) && data.resultados.length > 0;
          if(has){
            renderResults($widget, data);
          } else if (attempt < maxAttempts){
            showResultsLoading($widget, 'Procesando...');
            setTimeout(attemptFetch, intervalMs);
          } else {
            // No results after polling
            // Ensure forms are hidden and results area visible
            $widget.find('.impak-lc__form').hide();
            $widget.find('.impak-lc__results').show();
            renderResults($widget, { resultados: [] });
          }
        })
        .fail(function(){
          if (attempt < maxAttempts){
            showResultsLoading($widget, 'Procesando...');
            setTimeout(attemptFetch, intervalMs);
          } else {
            // Ensure forms are hidden and results area visible
            $widget.find('.impak-lc__form').hide();
            $widget.find('.impak-lc__results').show();
            renderResults($widget, { resultados: [] });
          }
        });
    }
    attemptFetch();
  }

  $(document).on('submit', '.impak-lc__form', function(e){
    e.preventDefault();
    var $form = $(this);
    var $widget = $form.closest('.impak-lc');

    if($form.hasClass('impak-lc__form--step1')){
      // Step 1: register -> process -> show step 2
      // Validate document
      var docType = ($form.find('[name="doc_type"]').val() || '').trim();
      var docNumber = ($form.find('[name="doc_number"]').val() || '').trim();
      // Clear previous errors
      clearFieldError($form.find('[name="doc_number"]'));
      var docErr = validateDocument(docType, docNumber);
      if(docErr){
        showFieldError($form.find('[name="doc_number"]'), docErr);
        $form.find('[name="doc_number"]').focus();
        return;
      }
      // Use amount slider value to define min/max rules
      var amountSel = parseInt(($form.find('#impak-lc-amount-hidden').val()||'').trim(), 10);
      var minAmount = null, maxAmount = null;
      if(!isNaN(amountSel) && amountSel >= 50){
        maxAmount = amountSel;
        // Rule: default min 50; if selected >= 200 then min = selected - 100
        minAmount = amountSel >= 200 ? (amountSel - 100) : 50;
        if(minAmount < 50) minAmount = 50;
      }

      // Parse term range like "30-90"
      var termVal = ($form.find('[name="term"]').val() || '').trim();
      var minTerm = null, maxTerm = null;
      if(termVal.indexOf('-') > -1){
        var tparts = termVal.split('-');
        if(tparts.length === 2){
          minTerm = parseInt(tparts[0], 10);
          maxTerm = parseInt(tparts[1], 10);
        }
        // Normalizar si vienen invertidos (permitimos igualdad)
        if(typeof minTerm === 'number' && typeof maxTerm === 'number' && !isNaN(minTerm) && !isNaN(maxTerm) && minTerm > maxTerm){
          var _swap = minTerm; minTerm = maxTerm; maxTerm = _swap;
        }
      } else if (termVal) {
        var tn = parseInt(termVal, 10);
        if(!isNaN(tn)){ minTerm = tn; maxTerm = tn; }
      }

      var d = {
        tipodocumento: docType,
        numerodocumento: docNumber,
        montominimo: minAmount,
        montomaximo: maxAmount,
        plazominimo: minTerm,
        plazomaximo: maxTerm,
      };
      // Validate required fields (treat 0 as valid number)
      var hasMissing = false;
      if(!d.tipodocumento){ showFieldError($form.find('[name="doc_type"]'), 'Selecciona el tipo de documento.'); hasMissing = true; }
      if(!d.numerodocumento){ showFieldError($form.find('[name="doc_number"]'), 'Ingresa el número de documento.'); hasMissing = true; }
      if(minAmount === null || isNaN(minAmount)){ showFieldError($form.find('#impak-lc-amount-range'), 'Selecciona un monto.'); hasMissing = true; }
      if(minTerm === null || isNaN(minTerm)){ showFieldError($form.find('[name="term"]'), 'Selecciona un plazo.'); hasMissing = true; }
      if(hasMissing){ return; }
      setLoading($form, true);
      $.ajax({
        url: apiUrl('/register'), method: 'POST', data: d, beforeSend: setAuthHeaders
      }).done(function(r){
        if(!(r && r.data)) {
          // No data -> show no offers and stop flow
          // Hide both forms just in case step 2 was visible
          $widget.find('.impak-lc__form').hide();
          var $res1 = $widget.find('.impak-lc__results');
          $res1.show();
          renderResults($widget, { resultados: [] });
          return $.Deferred().reject('NO_PROCESO').promise();
        }
        var procesoid = r.data.procesoid || (r.data.data && r.data.data.procesoid) || r.procesoid;
        if(!procesoid){
          // No procesoid -> show no offers and stop flow
          // Hide both forms just in case step 2 was visible
          $widget.find('.impak-lc__form').hide();
          var $res2 = $widget.find('.impak-lc__results');
          $res2.show();
          renderResults($widget, { resultados: [] });
          return $.Deferred().reject('NO_PROCESO').promise();
        }
        $widget.attr('data-procesoid', procesoid);
        // process step
        return $.ajax({ url: apiUrl('/process'), method: 'POST', data: { procesoid: procesoid }, beforeSend: setAuthHeaders });
      }).done(function(){
        // next step
        $form.hide();
        $widget.find('.impak-lc__form--step2').show();
      }).fail(function(jqXHR){
        // Suppress alert if this was our intentional early stop
        if(typeof jqXHR === 'string' && jqXHR === 'NO_PROCESO'){
          return;
        }
        var msg = 'Error en registro/proceso.';
        try{ var r = JSON.parse(jqXHR.responseText); if(r && r.message){ msg = r.message; } }catch(e){}
        alert(msg);
        console.error('Step1 error', jqXHR);
      }).always(function(){ setLoading($form, false); });
      return;
    }

    if($form.hasClass('impak-lc__form--step2')){
      // Step 2: complete -> results
      var procesoid = $widget.attr('data-procesoid') || '';
      var $nombres  = $form.find('[name="nombres"]');
      var $apellidos= $form.find('[name="apellidos"]');
      var $email    = $form.find('[name="correoelectronico"]');
      var $telefono = $form.find('[name="telefono"]');

      // Clear previous errors
      clearFieldError($nombres); clearFieldError($apellidos); clearFieldError($email); clearFieldError($telefono);

      var d2 = {
        procesoid: procesoid,
        nombres: ($nombres.val()||'').trim(),
        apellidos: ($apellidos.val()||'').trim(),
        correoelectronico: ($email.val()||'').trim(),
        telefono: ($telefono.val()||'').trim()
      };
      if(!procesoid){ showFieldError($nombres, 'Falta procesoid. Reinicia el proceso.'); return; }
      var hasErrors = false;
      if(!d2.nombres){ showFieldError($nombres, 'Ingresa tus nombres.'); hasErrors = true; }
      if(!d2.apellidos){ showFieldError($apellidos, 'Ingresa tus apellidos.'); hasErrors = true; }
      if(!d2.correoelectronico){ showFieldError($email, 'Ingresa tu correo electrónico.'); hasErrors = true; }
      else if(!validateEmail(d2.correoelectronico)){ showFieldError($email, 'Correo electrónico inválido.'); hasErrors = true; }
      if(!d2.telefono){ showFieldError($telefono, 'Ingresa tu teléfono.'); hasErrors = true; }
      else if(!validatePhone(d2.telefono)){ showFieldError($telefono, 'El teléfono debe tener 9 dígitos.'); hasErrors = true; }
      if(hasErrors){
        // Focus first invalid field
        var $first = $form.find('.is-invalid').first();
        if($first.length){ $first.focus(); }
        return;
      }
      setLoading($form, true);
      $.ajax({ url: apiUrl('/complete'), method: 'POST', data: d2, beforeSend: setAuthHeaders })
      .done(function(){
        $form.hide();
        var $res = $widget.find('.impak-lc__results');
        $res.show();
        showResultsLoading($widget, 'Procesando...');
        pollResults($widget, procesoid, { maxAttempts: 3, intervalMs: 3000 });
      })
      .fail(function(jqXHR){
        var msg = 'Error al completar/obtener resultados.';
        try{ var r = JSON.parse(jqXHR.responseText); if(r && r.message){ msg = r.message; } }catch(e){}
        alert(msg);
        console.error('Step2 error', jqXHR);
      })
      .always(function(){ setLoading($form, false); });
    }
  });

  $(document).on('click', '.impak-lc__notify', function(e){
    e.preventDefault();
    var $card = $(this).closest('.impak-lc__card');
    var entidadid = $card.attr('data-entidadid');
    var $widget = $(this).closest('.impak-lc');
    var procesoid = $widget.attr('data-procesoid');
    if(!entidadid || !procesoid){ alert('Faltan datos para notificar.'); return; }
    var $btn = $(this).prop('disabled', true).text('Enviando...');
    $.ajax({ url: apiUrl('/notify'), method: 'GET', data: { procesoid: procesoid, entidadid: entidadid }, beforeSend: setAuthHeaders })
    .done(function(r){
      // After notifying, ask user if they want to proceed to the entity page
      var resp = (r && r.data) ? r.data : {};
      var redirUrl = resp.url || $card.attr('data-url') || '';
      var postData = resp.postData || resp.payload || null; // prefer encrypted data if provided
      showConfirmModal($widget, {
        message: '¿Quiere iniciar el proceso con la entidad?',
        confirmText: 'Llévame ahora a la página de la entidad',
        cancelText: '⁠Lo haré en otro momento',
        onConfirm: function(){
          if(redirUrl){
            if(postData && typeof postData === 'object'){
              postToNewTab(redirUrl, postData);
            } else if (postData && typeof postData === 'string'){
              // If API returned a single encrypted blob, send as "payload"
              postToNewTab(redirUrl, { payload: postData });
            } else {
              // Fallback minimal data
              postToNewTab(redirUrl, { procesoid: procesoid, entidadid: entidadid });
            }
          } else {
            alert('No se recibió la URL de la entidad.');
          }
        }
      });
    })
    .fail(function(jqXHR){
      var msg = 'Error al notificar.';
      try{ var rr = JSON.parse(jqXHR.responseText); if(rr && rr.message){ msg = rr.message; } }catch(e){}
      alert(msg);
    })
    .always(function(){ $btn.prop('disabled', false).text('Seleccionar'); });
  });

  function showConfirmModal($widget, opts){
    opts = opts || {};
    var message = opts.message || '¿Continuar?';
    var confirmText = opts.confirmText || 'Confirmar';
    var cancelText = opts.cancelText || 'Cancelar';
    var onConfirm = typeof opts.onConfirm === 'function' ? opts.onConfirm : function(){};
    var onCancel  = typeof opts.onCancel  === 'function' ? opts.onCancel  : function(){};
    // Build modal
    var $overlay = $('<div class="impak-lc__modal-overlay" role="dialog" aria-modal="true"></div>');
    var $modal = $('<div class="impak-lc__modal"></div>');
    var $body = $('<div class="impak-lc__modal-body"></div>').text(message);
    var $actions = $('<div class="impak-lc__modal-actions"></div>');
    var $ok = $('<button type="button" class="impak-lc__btn impak-lc__btn--primary"></button>').text(confirmText);
    var $cancel = $('<button type="button" class="impak-lc__btn impak-lc__btn--ghost"></button>').text(cancelText);
    $actions.append($ok, $cancel);
    $modal.append($body, $actions);
    $overlay.append($modal);
    $widget.append($overlay);
    // Handlers
    $ok.on('click', function(){ $overlay.remove(); onConfirm(); });
    $cancel.on('click', function(){ $overlay.remove(); onCancel(); });
  }

  function postToNewTab(url, data){
    // Create a form and submit via POST to a new tab
    var form = document.createElement('form');
    form.method = 'POST';
    form.action = url;
    form.target = '_blank';
    for(var k in data){ if(!Object.prototype.hasOwnProperty.call(data,k)) continue; var v = data[k];
      var input = document.createElement('input');
      input.type = 'hidden'; input.name = k; input.value = typeof v === 'string' ? v : JSON.stringify(v);
      form.appendChild(input);
    }
    document.body.appendChild(form);
    form.submit();
    setTimeout(function(){ document.body.removeChild(form); }, 0);
  }

  // Back button: return to step 1 and reset
  $(document).on('click', '.impak-lc__back', function(e){
    e.preventDefault();
    var $widget = $(this).closest('.impak-lc');
    // Reset forms
    var $form1 = $widget.find('.impak-lc__form--step1');
    var $form2 = $widget.find('.impak-lc__form--step2');
    // Clear inputs/selects
    $form1[0] && $form1[0].reset();
    $form2[0] && $form2[0].reset();
    // Clear errors and invalid state
    $widget.find('.impak-lc__error').remove();
    $widget.find('.is-invalid').removeClass('is-invalid').attr('aria-invalid', 'false');
    // Hide results and show step1
    $widget.find('.impak-lc__results').hide();
    $form2.hide();
    $form1.show();
    // Clear procesoid
    $widget.attr('data-procesoid', '');
    // Remove no-results state class
    $widget.removeClass('impak-lc--no-results');
  });
})(jQuery);
